package com.atlassian.crowd.integration.rest.service;


import com.atlassian.crowd.service.client.ClientProperties;

import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;

/**
 * Abstraction for getting an {@link HttpClient}. Implementations can provide specialized clients, e.g. clients
 * with client-side caching support or connection pooling.
 */
public interface HttpClientProvider {
    /**
     * Get an {@link HttpClient} instance with the provided connection manager and request configuration.
     *
     * @param clientProperties the clientProperties for configuring the {@link HttpClient}.
     * @return an {@link HttpClient} configured with the given connection manager and request config.
     */
    CloseableHttpClient getClient(ClientProperties clientProperties);
}
