/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.service;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.JwtBuilder;
import com.atlassian.asap.api.client.http.AuthorizationHeaderGenerator;
import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.api.exception.InvalidTokenException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCrowdServiceException;
import com.atlassian.crowd.integration.rest.service.RestExecutor;
import com.atlassian.crowd.service.client.AuthenticationMethod;
import com.atlassian.crowd.service.client.ClientProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class AsapRestExecutor
extends RestExecutor {
    public static final String AUDIENCE = "crowd";
    private final AuthorizationHeaderGenerator authorizationHeaderGenerator;
    private final ClientProperties clientProperties;

    public static AsapRestExecutor createFrom(ClientProperties clientProperties, AuthorizationHeaderGenerator authorizationHeaderGenerator, CloseableHttpClient httpClient) {
        Preconditions.checkArgument((clientProperties.getAuthenticationMethod() == AuthenticationMethod.ASAP ? 1 : 0) != 0, (Object)"Client properties should specify ASAP auth as the authentication method");
        Preconditions.checkNotNull((Object)clientProperties.getAsapIssuer(), (Object)"Missing required Crowd client issuer name");
        Preconditions.checkNotNull((Object)clientProperties.getAsapKeyIdentifier(), (Object)"Missing required Crowd client key identifier");
        String baseUrl = AsapRestExecutor.createBaseUrl(clientProperties.getBaseURL());
        HttpHost httpHost = AsapRestExecutor.createHttpHost(clientProperties);
        CredentialsProvider credsProvider = AsapRestExecutor.createCredentialsProvider(clientProperties);
        return new AsapRestExecutor(baseUrl, httpHost, credsProvider, httpClient, authorizationHeaderGenerator, clientProperties);
    }

    @VisibleForTesting
    AsapRestExecutor(String baseUrl, HttpHost httpHost, CredentialsProvider credsProvider, CloseableHttpClient client, AuthorizationHeaderGenerator authorizationHeaderGenerator, ClientProperties clientProperties) {
        super(baseUrl, httpHost, credsProvider, client);
        this.authorizationHeaderGenerator = authorizationHeaderGenerator;
        this.clientProperties = clientProperties;
    }

    @Override
    protected RestExecutor.MethodExecutor createMethodExecutor(HttpUriRequest request, Set<Integer> statusCodesWithoutErrorEntity) {
        return new RestExecutor.MethodExecutor(request, statusCodesWithoutErrorEntity){

            @Override
            int executeCrowdServiceMethod() throws InvalidCrowdServiceException, IOException, InvalidAuthenticationException {
                Jwt jwt = JwtBuilder.newJwt().issuer(AsapRestExecutor.this.clientProperties.getAsapIssuer()).audience(new String[]{AsapRestExecutor.AUDIENCE}).keyId(AsapRestExecutor.this.clientProperties.getAsapKeyIdentifier()).subject(AsapRestExecutor.this.clientProperties.isAsapSubjectRequired() ? Optional.of(AsapRestExecutor.this.clientProperties.getApplicationName()) : Optional.empty()).build();
                try {
                    this.request.addHeader("Authorization", AsapRestExecutor.this.authorizationHeaderGenerator.generateAuthorizationHeader(jwt));
                }
                catch (CannotRetrieveKeyException | InvalidTokenException e) {
                    throw new InvalidAuthenticationException(e);
                }
                return super.executeCrowdServiceMethod();
            }
        };
    }
}

