package com.atlassian.crowd.integration.http;

import com.google.common.util.concurrent.Striped;

import java.util.concurrent.locks.Lock;

/**
 * Default implementation of {@link TokenLockProvider}, backed by Guava's {@link com.google.common.util.concurrent.Striped}
 * @since 3.2.0
 */
public class StripedTokenLockProvider implements TokenLockProvider {

    private final Striped<Lock> striped;

    public StripedTokenLockProvider() {
        this(32);
    }

    public StripedTokenLockProvider(int locksCount) {
        this(Striped.lock(locksCount));
    }

    public StripedTokenLockProvider(Striped<Lock> striped) {
        this.striped = striped;
    }

    @Override
    public Lock getLock(String token) {
        return striped.get(token);
    }
}
