/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http.util;

import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class CrowdHttpValidationFactorExtractorImpl
implements CrowdHttpValidationFactorExtractor {
    private static final CrowdHttpValidationFactorExtractor INSTANCE = new CrowdHttpValidationFactorExtractorImpl();

    private CrowdHttpValidationFactorExtractorImpl() {
    }

    @Override
    public List<ValidationFactor> getValidationFactors(HttpServletRequest request) {
        ArrayList<ValidationFactor> validationFactors = new ArrayList<ValidationFactor>();
        if (request != null) {
            String remoteAddressXForwardFor;
            String remoteAddress = request.getRemoteAddr();
            if (remoteAddress != null && remoteAddress.length() > 0) {
                validationFactors.add(new ValidationFactor("remote_address", remoteAddress));
            }
            if ((remoteAddressXForwardFor = request.getHeader("X-Forwarded-For")) != null && !remoteAddressXForwardFor.equals(remoteAddress)) {
                validationFactors.add(new ValidationFactor("X-Forwarded-For", remoteAddressXForwardFor));
            }
        }
        return validationFactors;
    }

    public static CrowdHttpValidationFactorExtractor getInstance() {
        return INSTANCE;
    }
}

