/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.client;

import java.util.Optional;

public enum ServiceDeskExtensionMode {
    NONE("none"),
    LOAD_LOCAL_IN_HORDE_FLAG("load-local-flag"),
    EXCLUDE_LOCAL_IN_HORDE_USERS("exclude-local-users");

    private String name;

    private ServiceDeskExtensionMode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this != NONE;
    }

    public boolean loadLocalInHordeFlag() {
        return this == LOAD_LOCAL_IN_HORDE_FLAG;
    }

    public boolean filterLocalInHordeUsers() {
        return this == EXCLUDE_LOCAL_IN_HORDE_USERS;
    }

    public static Optional<ServiceDeskExtensionMode> forModeName(String name) {
        for (ServiceDeskExtensionMode mode : ServiceDeskExtensionMode.values()) {
            if (!mode.getName().equals(name)) continue;
            return Optional.of(mode);
        }
        return Optional.empty();
    }
}

