package com.atlassian.crowd.search;

import java.util.List;
import java.util.stream.Collectors;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;

/**
 * Allows traversing a query's SearchRestriction, visiting each clause, and optionally mutating it's property restrictions.
 */
public abstract class SearchRestrictionVisitor {
    public SearchRestriction visit(SearchRestriction restriction) {
        if (restriction instanceof PropertyRestriction) {
            return visitPropertyRestriction((PropertyRestriction) restriction);
        } else if (restriction instanceof BooleanRestriction) {

            final BooleanRestriction boolRestriction = (BooleanRestriction) restriction;
            final List<SearchRestriction> restrictions = boolRestriction.getRestrictions().stream()
                    .map(this::visit)
                    .collect(Collectors.toList());
            return new BooleanRestrictionImpl(boolRestriction.getBooleanLogic(), restrictions);
        } else {
            return restriction;
        }
    }

    protected abstract SearchRestriction visitPropertyRestriction(PropertyRestriction restriction);
}
