package com.atlassian.crowd.saml;

import org.apache.commons.lang3.StringUtils;

/**
 * Contains constants used by Crowd when being a SAML Identity Provider
 *
 * @since 3.4.0
 */
public final class SamlConstants {

    /**
     * The prefix used for all custom Crowd Attributes in the SAML Assertion, both related to the Assertion's Subject,
     * as well as other misc ones
     */
    public static final String CROWD_ATTRIBUTES_PREFIX = "atl.crowd";

    /**
     * The prefix used for all SAML Assertion attributes that are not directly related to the Assertion's Subject
     */
    public static final String CROWD_MISC_PROPERTIES_PREFIX = CROWD_ATTRIBUTES_PREFIX + ".properties";

    /**
     * The attribute used for establishing a Remember Me session. A value of 'true' means that Crowd has issued a
     * Remember Me cookie for the authenticated user. This also means that the consumer of the assertion should issue
     * a Remember Me cookie for the authenticated user if possible.
     */
    public static final String REMEMBER_ME_ATTRIBUTE_NAME = CROWD_MISC_PROPERTIES_PREFIX + ".remember_me";

    /**
     * Suffix of plugin's SAML consumer URL.
     */
    public static final String PLUGIN_CONSUMER_SUFFIX = "plugins/servlet/samlconsumer";

    private SamlConstants() {}

    /**
     * Returns whether provided {@code samlConsumerUrl} matches plugin's SAML consumer URL suffix.
     */
    public static boolean isPluginConsumerUrl(final String samlConsumerUrl) {
        return StringUtils.stripEnd(samlConsumerUrl, "/").endsWith(PLUGIN_CONSUMER_SUFFIX);
    }
}
