package com.atlassian.crowd.search.builder;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;

import java.util.function.Function;

public class Restrictions {
    /**
     * Returns a condition that matches a user iff the provided {@code searchText} is a substring of any name related
     * field or an email field. String match is case insensitive.
     * @param searchText substring to search for
     * @return
     */
    public static BooleanRestriction userSearchRestriction(String searchText) {
        return Combine.anyOf(
                Restriction.on(UserTermKeys.USERNAME).containing(searchText),
                Restriction.on(UserTermKeys.DISPLAY_NAME).containing(searchText),
                Restriction.on(UserTermKeys.FIRST_NAME).containing(searchText),
                Restriction.on(UserTermKeys.LAST_NAME).containing(searchText),
                Restriction.on(UserTermKeys.EMAIL).containing(searchText)
        );
    }

    /**
     * Returns restriction for the provided {@code value} or {@link com.atlassian.crowd.search.query.entity.restriction.NullRestriction#INSTANCE}
     * if the {@code value} is null.
     * @param provider restriction provider, will be called only if {@code value} is not null
     * @param value restriction value
     * @return
     */
    public static <T> SearchRestriction optional(Function<T, SearchRestriction> provider, T value) {
        return value == null ? NullRestriction.INSTANCE : provider.apply(value);
    }
}
