package com.atlassian.crowd.model.group;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.DirectoryEntities;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;

/**
 * Utility class for {@link Group}
 *
 * @since v2.7
 */
public final class Groups {
    /**
     * A function that projects the group name
     *
     * @deprecated Use the more general {@link DirectoryEntities#NAME_FUNCTION}.
     */
    @Deprecated
    public static final Function<Group, String> NAME_FUNCTION = Group::getName;

    /**
     * A function that projects the lowercase group name
     *
     * @deprecated Use the more general {@link DirectoryEntities#LOWER_NAME_FUNCTION}.
     */
    @Deprecated
    public static final Function<Group, String> LOWER_NAME_FUNCTION =
            Functions.compose(IdentifierUtils.TO_LOWER_CASE, NAME_FUNCTION);

    private Groups() {
        // I'm a utility class. Please use my static methods, but don't instantiate me
    }

    /**
     * Transforms groups into their names.
     *
     * @param groups some groups
     * @return their names
     * @deprecated Use the more general {@link DirectoryEntities#namesOf}.
     */
    @Deprecated
    public static Iterable<String> namesOf(Iterable<? extends Group> groups) {
        return Iterables.transform(groups, NAME_FUNCTION);
    }
}
