package com.atlassian.crowd.model.event;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

import com.google.common.base.MoreObjects;

public class GroupMembershipEvent extends AbstractOperationEvent {
    private final String groupName;
    private final Set<String> parentGroupNames;
    private final Set<String> childGroupNames;

    public GroupMembershipEvent(Operation operation, Long directoryId, String groupName, String parentGroupName) {
        super(operation, directoryId);
        this.groupName = groupName;
        this.parentGroupNames = Collections.singleton(parentGroupName);
        this.childGroupNames = Collections.emptySet();
    }

    public GroupMembershipEvent(Operation operation, Long directoryId, String groupName, Set<String> parentGroupNames, Set<String> childGroupNames) {
        super(operation, directoryId);
        this.groupName = groupName;
        this.parentGroupNames = parentGroupNames;
        this.childGroupNames = childGroupNames;
    }

    public String getGroupName() {
        return groupName;
    }

    public Set<String> getParentGroupNames() {
        return parentGroupNames;
    }

    public Set<String> getChildGroupNames() {
        return childGroupNames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GroupMembershipEvent that = (GroupMembershipEvent) o;
        return Objects.equals(groupName, that.groupName) &&
                Objects.equals(parentGroupNames, that.parentGroupNames) &&
                Objects.equals(childGroupNames, that.childGroupNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), groupName, parentGroupNames, childGroupNames);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("groupName", groupName)
                .add("parentGroupNames", parentGroupNames)
                .add("childGroupNames", childGroupNames)
                .toString();
    }
}
