package com.atlassian.crowd.attribute;

import com.atlassian.crowd.embedded.api.Attributes;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

/**
 * Utility class for {@link Attributes} conversions.
 */
public class AttributeUtil {
    public static SetMultimap<String, String> toMultimap(Attributes attributes) {
        return toMultimap(attributes.getKeys(), key -> key, attributes::getValues);
    }

    public static SetMultimap<String, String> toMultimap(Map<String, Set<String>> map) {
        return toMultimap(map.entrySet(), Map.Entry::getKey, Map.Entry::getValue);
    }

    private static <T> SetMultimap<String, String> toMultimap(Iterable<T> entities, Function<T, String> key, Function<T, Collection<String>> value) {
        SetMultimap result = HashMultimap.create();
        for (T entity : entities) {
            result.putAll(key.apply(entity), value.apply(entity));
        }
        return result;
    }
}
