/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.manager;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.exceptions.ImporterConfigurationException;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.factory.ImporterFactory;
import com.atlassian.crowd.importer.importers.Importer;
import com.atlassian.crowd.importer.manager.ImporterManager;
import com.atlassian.crowd.importer.model.Result;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImporterManagerImpl
implements ImporterManager {
    private ImporterFactory importerFactory;

    @Override
    public Result performImport(Configuration configuation) throws ImporterException {
        if (configuation == null) {
            throw new IllegalArgumentException("You cannot supply a null Configuration");
        }
        configuation.isValid();
        Importer importer = this.importerFactory.getImporterDAO(configuation);
        return importer.importUsersGroupsAndMemberships(configuation);
    }

    @Override
    public void testConfiguration(Configuration configuration) throws ImporterConfigurationException {
        configuration.isValid();
    }

    @Override
    public Set<String> getSupportedApplications() {
        return this.importerFactory.getSupportedImporterApplications();
    }

    @Override
    public Set<String> getAtlassianSupportedApplications() {
        return this.importerFactory.getAtlassianSupportedImporterApplications();
    }

    public void setImporterFactory(ImporterFactory importerFactory) {
        this.importerFactory = importerFactory;
    }
}

