/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.config.JdbcConfiguration;
import com.atlassian.crowd.importer.exceptions.ImporterException;
import com.atlassian.crowd.importer.importers.ConfluenceHibernateImporter;
import com.atlassian.crowd.importer.importers.ConfluenceOSUserImporter;
import com.atlassian.crowd.importer.importers.Importer;
import com.atlassian.crowd.importer.importers.JdbcImporter;
import com.atlassian.crowd.importer.model.GroupMembership;
import com.atlassian.crowd.importer.model.Result;
import com.atlassian.crowd.integration.authentication.PasswordHelper;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import java.util.Collection;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfluenceImporter
implements Importer {
    private JdbcOperations jdbcTemplate;
    private DirectoryManager directoryManager;
    private PasswordHelper passwordHelper;
    private static final String HIBERNATE_USER_COUNT = "SELECT COUNT(id) FROM users";

    public ConfluenceImporter(DirectoryManager directoryManager, PasswordHelper passwordHelper) {
        this.directoryManager = directoryManager;
        this.passwordHelper = passwordHelper;
    }

    @Override
    public Result importUsersGroupsAndMemberships(Configuration configuration) throws ImporterException {
        if (configuration == null || !this.getConfigurationType().isInstance(configuration)) {
            throw new IllegalArgumentException("The supplied configuration was of the incorrect type for this Importer, should of been: " + this.getConfigurationType().getCanonicalName());
        }
        this.init(configuration);
        JdbcImporter confluenceImporter = this.isUsingHibernateUser() ? new ConfluenceHibernateImporter(this.directoryManager, this.passwordHelper) : new ConfluenceOSUserImporter(this.directoryManager, this.passwordHelper);
        return confluenceImporter.importUsersGroupsAndMemberships(configuration);
    }

    @Override
    public Collection<GroupMembership> findGroupMemberships(Configuration configuration) throws ImporterException {
        throw new UnsupportedOperationException("This method should not be called for the Confluence importer, only call this on the ConfluenceHibernateImporter or the ConfluenceOSUserImporter");
    }

    @Override
    public Collection<GroupTemplate> findGroups(Configuration configuration) throws ImporterException {
        throw new UnsupportedOperationException("This method should not be called for the Confluence importer, only call this on the ConfluenceHibernateImporter or the ConfluenceOSUserImporter");
    }

    @Override
    public Collection<UserTemplateWithCredentialAndAttributes> findUsers(Configuration configuration) throws ImporterException {
        throw new UnsupportedOperationException("This method should not be called for the Confluence importer, only call this on the ConfluenceHibernateImporter or the ConfluenceOSUserImporter");
    }

    @Override
    public void init(Configuration configuration) {
        this.setJdbcTemplate((JdbcConfiguration)configuration);
    }

    @Override
    public Class getConfigurationType() {
        return JdbcConfiguration.class;
    }

    private boolean isUsingHibernateUser() {
        return this.jdbcTemplate.queryForInt(HIBERNATE_USER_COUNT) > 0;
    }

    public void setJdbcTemplate(JdbcConfiguration configuration) {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource(configuration.getDatabaseDriver(), configuration.getDatabaseURL(), configuration.getUsername(), configuration.getPassword());
        this.jdbcTemplate = new JdbcTemplate((DataSource)driverManagerDataSource);
    }
}

