/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event.analytics;

import com.atlassian.crowd.event.analytics.EmbeddedCrowdAnalyticsEvent;
import java.util.Arrays;
import java.util.Objects;

public abstract class PasswordPolicyConfigurationAnalyticsEventBase
implements EmbeddedCrowdAnalyticsEvent {
    private final long directoryId;
    private final PresetName preset;
    private final MinimumLengthBucket minimumLength;
    private final MinimumCharactersBucket minimumLowercase;
    private final MinimumCharactersBucket minimumUppercase;
    private final MinimumCharactersBucket minimumDigits;
    private final MinimumCharactersBucket minimumSpecialCharacters;
    private final MinimumRulesMatched minimumRulesMatched;

    protected PasswordPolicyConfigurationAnalyticsEventBase(long directoryId, String preset, Integer minimumLength, Integer minimumLowercase, Integer minimumUppercase, Integer minimumDigits, Integer minimumSpecialCharacters, Integer minimumRulesMatched) {
        this.directoryId = directoryId;
        this.preset = PresetName.forPreset(preset);
        this.minimumLength = MinimumLengthBucket.forLength(minimumLength);
        this.minimumLowercase = MinimumCharactersBucket.forSetting(minimumLowercase);
        this.minimumUppercase = MinimumCharactersBucket.forSetting(minimumUppercase);
        this.minimumDigits = MinimumCharactersBucket.forSetting(minimumDigits);
        this.minimumSpecialCharacters = MinimumCharactersBucket.forSetting(minimumSpecialCharacters);
        boolean isEffectivelyDisabled = minimumRulesMatched == null && this.preset != PresetName.CUSTOM;
        this.minimumRulesMatched = isEffectivelyDisabled ? MinimumRulesMatched.DISABLED : MinimumRulesMatched.forSetting(minimumRulesMatched);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PasswordPolicyConfigurationAnalyticsEventBase that = (PasswordPolicyConfigurationAnalyticsEventBase)o;
        return Objects.equals(this.directoryId, that.directoryId) && Objects.equals((Object)this.preset, (Object)that.preset) && Objects.equals((Object)this.minimumLength, (Object)that.minimumLength) && Objects.equals((Object)this.minimumLowercase, (Object)that.minimumLowercase) && Objects.equals((Object)this.minimumUppercase, (Object)that.minimumUppercase) && Objects.equals((Object)this.minimumDigits, (Object)that.minimumDigits) && Objects.equals((Object)this.minimumSpecialCharacters, (Object)that.minimumSpecialCharacters) && Objects.equals((Object)this.minimumRulesMatched, (Object)that.minimumRulesMatched);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.directoryId, this.preset, this.minimumLength, this.minimumLowercase, this.minimumUppercase, this.minimumDigits, this.minimumSpecialCharacters, this.minimumRulesMatched});
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{directoryId=" + this.directoryId + ", preset=" + this.preset.getName() + ", minimumLength=" + this.minimumLength.getName() + ", minimumLowercase=" + this.minimumLowercase.getName() + ", minimumUppercase=" + this.minimumUppercase.getName() + ", minimumDigits=" + this.minimumDigits.getName() + ", minimumSpecialCharacters=" + this.minimumSpecialCharacters.getName() + ", minimumRulesMatched=" + this.minimumRulesMatched.getName() + "}";
    }

    public String getMinimumLength() {
        return this.minimumLength.getName();
    }

    public String getMinimumLowercase() {
        return this.minimumLowercase.getName();
    }

    public String getMinimumUppercase() {
        return this.minimumUppercase.getName();
    }

    public String getMinimumDigits() {
        return this.minimumDigits.getName();
    }

    public String getMinimumSpecialCharacters() {
        return this.minimumSpecialCharacters.getName();
    }

    public String getMinimumRulesMatched() {
        return this.minimumRulesMatched.getName();
    }

    protected String eventName() {
        return "crowd.statistics.directory.internal.password.policy." + this.preset.getName();
    }

    public static enum PresetName {
        DISABLED,
        RECOMMENDED,
        CUSTOM;


        public String getName() {
            return this.name().toLowerCase();
        }

        public static PresetName forPreset(String preset) {
            return Arrays.stream(PresetName.values()).filter(option -> option.name().equalsIgnoreCase(preset)).findAny().orElse(DISABLED);
        }
    }

    public static enum MinimumLengthBucket {
        DISABLED,
        ONE_TO_EIGHT,
        NINE_TO_SIXTEEN,
        SEVENTEEN_TO_TWENTYFOUR,
        MORE_THAN_TWENTYFOUR;


        public String getName() {
            return this.name().toLowerCase();
        }

        public static MinimumLengthBucket forLength(Integer length) {
            if (length == null || length <= 0) {
                return DISABLED;
            }
            if (length <= 8) {
                return ONE_TO_EIGHT;
            }
            if (length <= 16) {
                return NINE_TO_SIXTEEN;
            }
            if (length <= 24) {
                return SEVENTEEN_TO_TWENTYFOUR;
            }
            return MORE_THAN_TWENTYFOUR;
        }
    }

    public static enum MinimumCharactersBucket {
        DISABLED,
        ONE,
        MORE_THAN_ONE;


        public String getName() {
            return this.name().toLowerCase();
        }

        public static MinimumCharactersBucket forSetting(Integer value) {
            if (value == null || value <= 0) {
                return DISABLED;
            }
            if (value == 1) {
                return ONE;
            }
            return MORE_THAN_ONE;
        }
    }

    public static enum MinimumRulesMatched {
        DISABLED,
        ONE,
        TWO,
        THREE,
        ALL;


        public String getName() {
            return this.name().toLowerCase();
        }

        public static MinimumRulesMatched forSetting(Integer value) {
            if (value == null) {
                return ALL;
            }
            if (value <= 0) {
                return DISABLED;
            }
            if (value == 1) {
                return ONE;
            }
            if (value == 2) {
                return TWO;
            }
            if (value == 3) {
                return THREE;
            }
            return ALL;
        }
    }
}

