package com.atlassian.crowd.event.user;

import java.util.Collection;
import java.util.Objects;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.DirectoryEvent;

/**
 * An Event that represents the deletion of one or more {@link com.atlassian.crowd.model.user.User}s.
 *
 * @since 2.11
 */
public class UsersDeletedEvent extends DirectoryEvent {
    private Collection<String> usernames;

    public UsersDeletedEvent(Object source, Directory directory, Collection<String> usernames) {
        super(source, directory);
        this.usernames = usernames;
    }

    public Collection<String> getUsernames() {
        return usernames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        UsersDeletedEvent that = (UsersDeletedEvent) o;
        return Objects.equals(usernames, that.usernames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), usernames);
    }
}
