package com.atlassian.crowd.event.user;

import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.User;

import java.util.Objects;

/**
 * An Event that represents the updating of a {@link com.atlassian.crowd.model.user.User}
 *
 * This is a generic event. Depending on what exactly happened a specific subclass will be published
 */
public abstract class UserUpdatedEvent extends DirectoryEvent {
    private final ImmutableUser user;

    public UserUpdatedEvent(Object source, Directory directory, User user) {
        super(source, directory);
        this.user = ImmutableUser.from(user);
    }

    public User getUser() {
        return user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        UserUpdatedEvent that = (UserUpdatedEvent) o;
        return Objects.equals(user, that.user);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), user);
    }
}
