package com.atlassian.crowd.event.user;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.token.Token;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

import java.util.Objects;

public class UserTokenVerificationSucceededEvent {
    private final ImmutableApplication application;
    private final Token token;

    public UserTokenVerificationSucceededEvent(Application application, Token token) {
        this(ImmutableApplication.from(application), token);
    }

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    public UserTokenVerificationSucceededEvent(ImmutableApplication application, Token token) {
        this.application = Preconditions.checkNotNull(application);
        this.token = Preconditions.checkNotNull(token);
    }

    public ImmutableApplication getApplication() {
        return application;
    }

    public Token getToken() {
        return token;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UserTokenVerificationSucceededEvent that = (UserTokenVerificationSucceededEvent) o;

        return Objects.equals(this.getApplication(), that.getApplication()) &&
                Objects.equals(this.getToken(), that.getToken());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getApplication(), getToken());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("application", getApplication())
                .add("token", getToken())
                .toString();
    }
}
