package com.atlassian.crowd.event.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.user.User;

import java.util.Objects;

/**
 * A simple ResetPasswordEvent. Fired when the password is reset (via "I forgot my password"), rather than changed to a
 * new value.
 */
public class ResetPasswordEvent extends UserUpdatedEvent {
    private final String newPassword;

    public ResetPasswordEvent(Object source, Directory directory, User user, String newPassword) {
        super(source, directory, user);
        this.newPassword = newPassword;
    }

    public String getNewPassword() {
        return newPassword;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResetPasswordEvent that = (ResetPasswordEvent) o;
        return Objects.equals(newPassword, that.newPassword);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), newPassword);
    }
}
