package com.atlassian.crowd.event.links;

import com.atlassian.crowd.event.EnumBasedEvent;
import com.google.common.collect.ImmutableMap;

/**
 * Event for reporting external links clicks.
 */
public class ExternalLinkClickedEvent extends EnumBasedEvent<ExternalLinkClickedEvent.TargetLink> {
    public enum TargetLink {
        SETUP_PANOPTICON,
        LICENSING_GETTING_STARTED
    }

    public static ImmutableMap<TargetLink, ExternalLinkClickedEvent> BY_TARGET =
            createMapByEnum(TargetLink.values(), ExternalLinkClickedEvent::new);

    public static ExternalLinkClickedEvent from(TargetLink targetLink) {
        return BY_TARGET.get(targetLink);
    }

    private ExternalLinkClickedEvent(TargetLink targetLink) {
        super(targetLink);
    }

    public TargetLink getTargetLink() {
        return data;
    }
}
