package com.atlassian.crowd.event.licensing;

import com.atlassian.crowd.event.EnumBasedEvent;
import com.google.common.collect.ImmutableMap;

/**
 * Event for licensing tab view.
 */
public class LicensingTabViewEvent extends EnumBasedEvent<LicensingTabViewEvent.Status> {
    public enum Status {
        NOT_CONFIGURED,
        LOADING,
        EMPTY_SEARCH_RESULTS,
        NON_EMPTY_SEARCH_RESULTS
    }

    public static final ImmutableMap<Status, LicensingTabViewEvent> BY_STATUS =
            createMapByEnum(Status.values(), LicensingTabViewEvent::new);

    public static LicensingTabViewEvent from(Status status) {
        return BY_STATUS.get(status);
    }

    private LicensingTabViewEvent(Status status) {
        super(status);
    }

    public Status getStatus() {
        return data;
    }
}
