package com.atlassian.crowd.event.groupleveladmin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.ImmutableGroup;
import com.google.common.base.MoreObjects;

import java.util.Objects;

public class UserBecameGroupAdministratorEvent {
    private final ImmutableGroup group;
    private final User administrator;

    public UserBecameGroupAdministratorEvent(Group group, User administrator) {
        this.group = ImmutableGroup.from(group);
        this.administrator = administrator;
    }

    public Group getGroup() {
        return group;
    }

    public User getAdministrator() {
        return administrator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserBecameGroupAdministratorEvent that = (UserBecameGroupAdministratorEvent) o;
        return Objects.equals(group, that.group) &&
                Objects.equals(administrator, that.administrator);
    }

    @Override
    public int hashCode() {
        return Objects.hash(group, administrator);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("group", group)
                .add("administrator", administrator)
                .toString();
    }
}
