package com.atlassian.crowd.event.groupleveladmin;

import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.ImmutableGroup;
import com.google.common.base.MoreObjects;

import java.util.Objects;

public class GroupBecameGroupAdministratorEvent {
    private final ImmutableGroup administeredGroup;
    private final ImmutableGroup administrationGroup;

    public GroupBecameGroupAdministratorEvent(Group administeredGroup, Group administrationGroup) {
        this.administeredGroup = ImmutableGroup.from(administeredGroup);
        this.administrationGroup = ImmutableGroup.from(administrationGroup);
    }

    public Group getAdministeredGroup() {
        return administeredGroup;
    }

    public Group getAdministeringGroup() {
        return administrationGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GroupBecameGroupAdministratorEvent that = (GroupBecameGroupAdministratorEvent) o;
        return Objects.equals(administeredGroup, that.administeredGroup) &&
                Objects.equals(administrationGroup, that.administrationGroup);
    }

    @Override
    public int hashCode() {
        return Objects.hash(administeredGroup, administrationGroup);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("administeredGroup", administeredGroup)
                .add("administrationGroup", administrationGroup)
                .toString();
    }
}
