package com.atlassian.crowd.event.directory;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;
import com.atlassian.crowd.event.Event;
import com.google.common.base.Objects;

import javax.annotation.Nullable;
import java.util.Optional;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Superclass for events thrown when a directory synchronisation finishes.
 */
public abstract class RemoteDirectorySynchronisationFinishedEvent extends Event {
    private final RemoteDirectory remoteDirectory;
    @Nullable
    private final DirectorySynchronisationRoundInformation lastRound;
    private final long timeTakenInMs;

    public RemoteDirectorySynchronisationFinishedEvent(
            Object source,
            RemoteDirectory remoteDirectory,
            @Nullable DirectorySynchronisationRoundInformation lastRound,
            long timeTakenInMs) {
        super(source);
        checkNotNull(remoteDirectory);
        
        this.remoteDirectory = remoteDirectory;
        this.lastRound = lastRound;
        this.timeTakenInMs = timeTakenInMs;
    }

    public RemoteDirectory getRemoteDirectory() {
        return remoteDirectory;
    }

    // accessor for Analytics
    public long getDirectoryId() {
        return remoteDirectory.getDirectoryId();
    }

    public Optional<DirectorySynchronisationRoundInformation> getLastRound() {
        return Optional.ofNullable(lastRound);
    }

    public long getTimeTakenInMs() {
        return timeTakenInMs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RemoteDirectorySynchronisationFinishedEvent that = (RemoteDirectorySynchronisationFinishedEvent) o;
        return timeTakenInMs == that.timeTakenInMs &&
                Objects.equal(remoteDirectory, that.remoteDirectory) &&
                Objects.equal(lastRound, that.lastRound);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(remoteDirectory, lastRound, timeTakenInMs);
    }
}
