package com.atlassian.crowd.event.configuration;

import com.atlassian.crowd.model.lookandfeel.LookAndFeelConfiguration;

import java.util.Objects;

/**
 * This class represents an update to Crowd's look and feel configuration.
 * It contains the configuration before and after the change.
 *
 * @since 4.2.0
 */
public class LookAndFeelUpdatedEvent {
    private final LookAndFeelConfiguration oldConfiguration;
    private final LookAndFeelConfiguration newConfiguration;

    public LookAndFeelUpdatedEvent(LookAndFeelConfiguration oldConfiguration, LookAndFeelConfiguration newConfiguration) {
        this.oldConfiguration = oldConfiguration;
        this.newConfiguration = newConfiguration;
    }

    public LookAndFeelConfiguration getOldConfiguration() {
        return oldConfiguration;
    }

    public LookAndFeelConfiguration getNewConfiguration() {
        return newConfiguration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LookAndFeelUpdatedEvent that = (LookAndFeelUpdatedEvent) o;
        return Objects.equals(oldConfiguration, that.oldConfiguration) &&
                Objects.equals(newConfiguration, that.newConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(oldConfiguration, newConfiguration);
    }
}
