package com.atlassian.crowd.event.configuration;

import java.util.List;
import java.util.Objects;

/**
 * This class represents an update to the logging configuration. It is published when there was a change to the configured
 * loggers. It contains a list of loggers before and after the update.
 *
 * @since 2.12.0
 */
public class LoggingUpdatedEvent {
    private final List<LoggingConfig> oldConfiguration;
    private final List<LoggingConfig> newConfiguration;

    public LoggingUpdatedEvent(List<LoggingConfig> oldConfiguration, List<LoggingConfig> newConfiguration) {
        this.oldConfiguration = oldConfiguration;
        this.newConfiguration = newConfiguration;
    }

    public List<LoggingConfig> getOldConfiguration() {
        return oldConfiguration;
    }

    public List<LoggingConfig> getNewConfiguration() {
        return newConfiguration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LoggingUpdatedEvent that = (LoggingUpdatedEvent) o;
        return Objects.equals(oldConfiguration, that.oldConfiguration) &&
                Objects.equals(newConfiguration, that.newConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(oldConfiguration, newConfiguration);
    }

    /**
     * Represents a logging configuration entry, corresponding to a Class or Package mapped to a Level.
     */
    public static class LoggingConfig {

        private final String clazz;
        private final String level;

        public LoggingConfig(String clazz, String level) {
            this.clazz = clazz;
            this.level = level;
        }

        public String getClazz() {
            return clazz;
        }

        public String getLevel() {
            return level;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            LoggingConfig that = (LoggingConfig) o;
            return Objects.equals(clazz, that.clazz) &&
                    Objects.equals(level, that.level);
        }

        @Override
        public int hashCode() {
            return Objects.hash(clazz, level);
        }
    }

}
