package com.atlassian.crowd.event.application;

import com.atlassian.crowd.model.sso.ApplicationSamlConfiguration;

import java.util.Objects;

/**
 * Event which occurs when a SAML configuration within application is changed.
 */
public class ApplicationSamlConfigurationUpdatedEvent {
    protected final ApplicationSamlConfiguration oldApplicationSamlConfiguration;
    protected final ApplicationSamlConfiguration newApplicationSamlConfiguration;

    public ApplicationSamlConfigurationUpdatedEvent(ApplicationSamlConfiguration oldApplicationSamlConfiguration,
                                                    ApplicationSamlConfiguration newApplicationSamlConfiguration) {
        this.oldApplicationSamlConfiguration = oldApplicationSamlConfiguration;
        this.newApplicationSamlConfiguration = newApplicationSamlConfiguration;
    }

    public ApplicationSamlConfiguration getOldApplicationSamlConfiguration() {
        return oldApplicationSamlConfiguration;
    }

    public ApplicationSamlConfiguration getNewApplicationSamlConfiguration() {
        return newApplicationSamlConfiguration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApplicationSamlConfigurationUpdatedEvent that = (ApplicationSamlConfigurationUpdatedEvent) o;
        return Objects.equals(oldApplicationSamlConfiguration, that.oldApplicationSamlConfiguration) &&
                Objects.equals(newApplicationSamlConfiguration, that.newApplicationSamlConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(oldApplicationSamlConfiguration, newApplicationSamlConfiguration);
    }
}
