package com.atlassian.crowd.event.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.directory.ImmutableDirectory;

/**
 * Event which occurs when a directory is moved to another position in
 * Application's list of included directories.
 */
public class ApplicationDirectoryOrderUpdatedEvent extends ApplicationUpdatedEvent {
    private final ImmutableDirectory directory;

    public ApplicationDirectoryOrderUpdatedEvent(final Application oldApplication, final Application application, final Directory directory) {
        super(oldApplication, application);
        this.directory = ImmutableDirectory.from(directory);
    }

    public Directory getDirectory() {
        return directory;
    }

    // accessor for Analytics
    public Long getDirectoryId() {
        return directory.getId();
    }
}
