package com.atlassian.crowd.event.application;


import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;

import com.google.common.base.Objects;

/**
 * Event published when an application has been deleted
 *
 * @since 2.12.0
 */
public class ApplicationDeletedEvent {
    private final ImmutableApplication application;

    public ApplicationDeletedEvent(Application application) {
        this.application = ImmutableApplication.from(application);
    }

    /**
     * Returns application which was recently deleted
     *
     * @return deleted application
     */
    public Application getApplication() {
        return application;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApplicationDeletedEvent that = (ApplicationDeletedEvent) o;
        return Objects.equal(application, that.application);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(application);
    }
}
