package com.atlassian.crowd.event.application;


import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

/**
 * Event published when a new application has been created
 *
 * @since 2.12.0
 */
public class ApplicationCreatedEvent {
    private final ImmutableApplication application;

    public ApplicationCreatedEvent(Application application) {
        this.application = ImmutableApplication.from(application);
    }

    /**
     * Returns application which was created
     *
     * @return created application
     */
    public Application getApplication() {
        return application;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApplicationCreatedEvent that = (ApplicationCreatedEvent) o;
        return Objects.equal(application, that.application);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(application);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("application", application)
                .toString();
    }
}
