package com.atlassian.crowd.event.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.user.User;

import java.util.Objects;

/**
 * An event which is published after a user's email address is updated
 */
public class UserEmailChangedEvent extends UserUpdatedEvent {
    private final String originalEmail;

    public UserEmailChangedEvent(final Object source, final Directory directory, final User user, final String originalEmail) {
        super(source, directory, user);

        this.originalEmail = originalEmail;
    }

    public String getOriginalEmail() {
        return originalEmail;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        UserEmailChangedEvent that = (UserEmailChangedEvent) o;
        return Objects.equals(originalEmail, that.originalEmail);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), originalEmail);
    }
}
