package com.atlassian.crowd.event.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.User;
import com.google.common.base.Preconditions;

import java.util.Objects;

/**
 * An event that is published when user is edited
 */
public class UserEditedEvent extends UserUpdatedEvent {
    private final ImmutableUser originalUser;

    public UserEditedEvent(final Object source, final Directory directory, final User user, final User originalUser) {
        super(source, directory, user);
        Preconditions.checkArgument(originalUser != user);
        this.originalUser = ImmutableUser.from(originalUser);
    }

    public User getOriginalUser() {
        return originalUser;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        UserEditedEvent that = (UserEditedEvent) o;
        return Objects.equals(originalUser, that.originalUser);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), originalUser);
    }
}
