package com.atlassian.crowd.event.user;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.embedded.api.Directory;

import java.util.Objects;

/**
 * An Event that is fired when a user (principal) changes their password (credential).
 */
public class UserCredentialUpdatedEvent extends DirectoryEvent {
    private final String username;
    private final PasswordCredential newCredential;

    public UserCredentialUpdatedEvent(Object source, Directory directory, String username, PasswordCredential newCredential) {
        super(source, directory);

        this.username = username;
        this.newCredential = newCredential;
    }

    public String getUsername() {
        return username;
    }

    public PasswordCredential getNewCredential() {
        return newCredential;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        UserCredentialUpdatedEvent that = (UserCredentialUpdatedEvent) o;
        return Objects.equals(username, that.username) &&
                Objects.equals(newCredential, that.newCredential);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), username, newCredential);
    }
}
