package com.atlassian.crowd.event.user;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.User;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;

import java.util.Objects;

/**
 * This event is published when a user has been successfully authenticated
 * to application through SAML SSO.
 */
public class UserAuthenticatedWithSamlSsoEvent {
    private final ImmutableApplication application;
    private final ImmutableUser user;
    private final boolean atlassianSamlPlugin;

    public UserAuthenticatedWithSamlSsoEvent(Application application, User user, boolean atlassianSamlPlugin) {
        this(ImmutableApplication.from(application), ImmutableUser.from(user), atlassianSamlPlugin);
    }

// The code below has been generated by Bob the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke Bob again.

    public UserAuthenticatedWithSamlSsoEvent(ImmutableApplication application, ImmutableUser user, boolean atlassianSamlPlugin) {
        this.application = Preconditions.checkNotNull(application);
        this.user = Preconditions.checkNotNull(user);
        this.atlassianSamlPlugin = atlassianSamlPlugin;
    }

    public ImmutableApplication getApplication() {
        return application;
    }

    public ImmutableUser getUser() {
        return user;
    }

    public boolean getAtlassianSamlPlugin() {
        return atlassianSamlPlugin;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        UserAuthenticatedWithSamlSsoEvent that = (UserAuthenticatedWithSamlSsoEvent) o;

        return Objects.equals(this.getApplication(), that.getApplication()) &&
                Objects.equals(this.getUser(), that.getUser()) &&
                Objects.equals(this.getAtlassianSamlPlugin(), that.getAtlassianSamlPlugin());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getApplication(), getUser(), getAtlassianSamlPlugin());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("application", getApplication())
                .add("user", getUser())
                .add("atlassianSamlPlugin", getAtlassianSamlPlugin())
                .toString();
    }
}
