package com.atlassian.crowd.event.groupleveladmin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.ImmutableGroup;
import com.google.common.base.MoreObjects;

import java.util.Objects;

public class UserStoppedBeingGroupAdministratorEvent {
    private final ImmutableGroup group;
    private final User user;

    public UserStoppedBeingGroupAdministratorEvent(Group group, User user) {
        this.group = ImmutableGroup.from(group);
        this.user = user;
    }

    public Group getGroup() {
        return group;
    }

    public User getUser() {
        return user;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        UserStoppedBeingGroupAdministratorEvent that = (UserStoppedBeingGroupAdministratorEvent) o;
        return Objects.equals(group, that.group) &&
                Objects.equals(user, that.user);
    }

    @Override
    public int hashCode() {
        return Objects.hash(group, user);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("group", group)
                .add("user", user)
                .toString();
    }
}
