package com.atlassian.crowd.event.groupleveladmin;

import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.ImmutableGroup;
import com.google.common.base.MoreObjects;

import java.util.Objects;

public class GroupStoppedBeingGroupAdministratorEvent {
    private final ImmutableGroup administeringGroup;
    private final ImmutableGroup administeredGroup;

    public GroupStoppedBeingGroupAdministratorEvent(Group administeringGroup, Group administeredGroup) {
        this.administeringGroup = ImmutableGroup.from(administeringGroup);
        this.administeredGroup = ImmutableGroup.from(administeredGroup);
    }

    public Group getAdministeringGroup() {
        return administeringGroup;
    }

    public Group getAdministeredGroup() {
        return administeredGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GroupStoppedBeingGroupAdministratorEvent that = (GroupStoppedBeingGroupAdministratorEvent) o;
        return Objects.equals(administeringGroup, that.administeringGroup) &&
                Objects.equals(administeredGroup, that.administeredGroup);
    }

    @Override
    public int hashCode() {
        return Objects.hash(administeringGroup, administeredGroup);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("administeringGroup", administeringGroup)
                .add("administeredGroup", administeredGroup)
                .toString();
    }
}
