package com.atlassian.crowd.event.group;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.ImmutableGroup;

import java.util.Objects;

/**
 * An Event that represents the updating of a {@link com.atlassian.crowd.model.group.Group}
 */
public class GroupUpdatedEvent extends DirectoryEvent {
    private final ImmutableGroup group;

    public GroupUpdatedEvent(Object source, Directory directory, Group group) {
        super(source, directory);
        this.group = ImmutableGroup.from(group);
    }

    public Group getGroup() {
        return group;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GroupUpdatedEvent that = (GroupUpdatedEvent) o;
        return Objects.equals(group, that.group);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), group);
    }
}
