package com.atlassian.crowd.event.group;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.model.membership.MembershipType;

import java.util.Objects;

/**
 * An Event that represents the creation of a Principal/Child Group to Group membership
 *
 * @deprecated Use {@link GroupMembershipsCreatedEvent} instead. Since 2.10.
 */
@Deprecated
public class GroupMembershipCreatedEvent extends DirectoryEvent {
    private final String entityName;
    private final String groupName;
    private final MembershipType membershipType;

    public GroupMembershipCreatedEvent(Object source, Directory directory, String entityName, String groupName, MembershipType membershipType) {
        super(source, directory);
        this.entityName = entityName;
        this.groupName = groupName;
        this.membershipType = membershipType;
    }

    public String getEntityName() {
        return entityName;
    }

    public String getGroupName() {
        return groupName;
    }

    public MembershipType getMembershipType() {
        return membershipType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GroupMembershipCreatedEvent that = (GroupMembershipCreatedEvent) o;
        return Objects.equals(entityName, that.entityName) &&
                Objects.equals(groupName, that.groupName) &&
                membershipType == that.membershipType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), entityName, groupName, membershipType);
    }
}
