package com.atlassian.crowd.event.directory;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;

import javax.annotation.Nullable;

/**
 * This event is analogous to {@link RemoteDirectorySynchronisedEvent}, however it's published when a directory
 * synchronisation fails.
 */
public class RemoteDirectorySynchronisationFailedEvent extends RemoteDirectorySynchronisationFinishedEvent {
    public RemoteDirectorySynchronisationFailedEvent(
            Object source,
            RemoteDirectory remoteDirectory,
            @Nullable DirectorySynchronisationRoundInformation lastRound,
            long timeTakenInMs) {
        super(source, remoteDirectory, lastRound, timeTakenInMs);
    }
}
