package com.atlassian.crowd.event.directory;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.model.directory.ImmutableDirectory;

import javax.annotation.Nonnull;
import java.util.Objects;

public class DirectoryUpdatedEvent extends DirectoryEvent {
    private final Directory oldDirectory;

    @Deprecated
    public DirectoryUpdatedEvent(Object source, Directory directory) {
        this(source, directory, null);
    }

    public DirectoryUpdatedEvent(Object source, Directory oldDirectory, @Nonnull Directory newDirectory) {
        super(source, newDirectory);
        this.oldDirectory = oldDirectory == null ? null : ImmutableDirectory.from(oldDirectory);
    }

    public Directory getOldDirectory() {
        return oldDirectory;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DirectoryUpdatedEvent that = (DirectoryUpdatedEvent) o;
        return Objects.equals(oldDirectory, that.oldDirectory);
    }

    @Override
    public int hashCode() {

        return Objects.hash(super.hashCode(), oldDirectory);
    }
}
