package com.atlassian.crowd.event.configuration;

import java.util.Objects;

import javax.annotation.Nullable;

import com.atlassian.crowd.util.mail.SMTPServer;

/**
 * This class represents an update to Crowd's mail configuration. It contains the mail configuration before and after
 * the change. If mailing was not configured then the property will be null.
 *
 * @since 2.12.0
 */
public class SmtpServerUpdatedEvent {

    private final SMTPServer oldValue;
    private final SMTPServer newValue;

    public SmtpServerUpdatedEvent(@Nullable SMTPServer oldValue, @Nullable SMTPServer newValue) {
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Nullable
    public SMTPServer getOldValue() {
        return oldValue;
    }

    @Nullable
    public SMTPServer getNewValue() {
        return newValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SmtpServerUpdatedEvent that = (SmtpServerUpdatedEvent) o;
        return Objects.equals(oldValue, that.oldValue) &&
                Objects.equals(newValue, that.newValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(oldValue, newValue);
    }
}
