package com.atlassian.crowd.event.configuration;

import java.util.Objects;

/**
 * This class represents a simple property update, mainly meant for configuration changes in Crowd. This event will be
 * translated to a single-entried audit log changeset with an event type of MODIFIED and an entity type of CONFIGURATION.
 * The author will be set to the currently authenticated user (if available) and entity name/id empty. The entry's
 * properties will match the properties specified in these events and will be sanitised if need be.
 *
 * @since 2.12.0
 */
public class ConfigurationPropertyUpdatedEvent {

    private final String propertyName;
    private final String oldValue;
    private final String newValue;

    public ConfigurationPropertyUpdatedEvent(String propertyName, String oldValue, String newValue) {
        this.propertyName = propertyName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public String getOldValue() {
        return oldValue;
    }

    public String getNewValue() {
        return newValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConfigurationPropertyUpdatedEvent that = (ConfigurationPropertyUpdatedEvent) o;
        return Objects.equals(propertyName, that.propertyName) &&
                Objects.equals(oldValue, that.oldValue) &&
                Objects.equals(newValue, that.newValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(propertyName, oldValue, newValue);
    }
}
