package com.atlassian.crowd.event.configuration;

import com.atlassian.crowd.manager.audit.AuditLogConfiguration;
import com.google.common.base.MoreObjects;

import java.util.Objects;

/**
 * This class represents an update to the auditing configuration. Published when auditing configuration changes
 *
 * @since 2.12.0
 */
public class AuditLogConfigurationUpdatedEvent {
    private final AuditLogConfiguration oldConfiguration;
    private final AuditLogConfiguration newConfiguration;

    public AuditLogConfigurationUpdatedEvent(AuditLogConfiguration oldConfiguration, AuditLogConfiguration newConfiguration) {
        this.oldConfiguration = oldConfiguration;
        this.newConfiguration = newConfiguration;
    }

    public AuditLogConfiguration getOldConfiguration() {
        return oldConfiguration;
    }

    public AuditLogConfiguration getNewConfiguration() {
        return newConfiguration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AuditLogConfigurationUpdatedEvent that = (AuditLogConfigurationUpdatedEvent) o;
        return Objects.equals(oldConfiguration, that.oldConfiguration) &&
                Objects.equals(newConfiguration, that.newConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(oldConfiguration, newConfiguration);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("oldConfiguration", oldConfiguration)
                .add("newConfiguration", newConfiguration)
                .toString();
    }
}
