package com.atlassian.crowd.event.application;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;

import com.google.common.base.Objects;

/**
 * Occurs when the configuration of an newApplication changes.
 *
 * @see ApplicationDirectoryAddedEvent
 * @see ApplicationDirectoryRemovedEvent
 * @see ApplicationDirectoryOrderUpdatedEvent
 * @see ApplicationRemoteAddressAddedEvent
 * @see ApplicationRemoteAddressRemovedEvent
 * @since v2.6.2
 */
public class ApplicationUpdatedEvent {
    protected final ImmutableApplication newApplication;
    protected final ImmutableApplication oldApplication;

    public ApplicationUpdatedEvent(Application oldApplication, Application newApplication) {
        this.oldApplication = ImmutableApplication.from(oldApplication);
        this.newApplication = ImmutableApplication.from(newApplication);
    }

    /**
     * Returns state of the application after the update
     *
     * @return new application
     */
    public Application getApplication() {
        return newApplication;
    }

    /**
     * Returns state of the application before the update
     *
     * @return
     */
    public Application getOldApplication() {
        return oldApplication;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApplicationUpdatedEvent that = (ApplicationUpdatedEvent) o;
        return Objects.equal(newApplication, that.newApplication) &&
                Objects.equal(oldApplication, that.oldApplication);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(newApplication, oldApplication);
    }

    // accessor for Analytics
    public Long getApplicationId() {
        return newApplication.getId();
    }
}
