package com.atlassian.crowd.event.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.directory.ImmutableDirectory;

/**
 * Event which occurs when a directory is removed from an Application's list of
 * included directories.
 */
public class ApplicationDirectoryRemovedEvent extends ApplicationUpdatedEvent {
    private final ImmutableDirectory directory;

    @Deprecated
    public ApplicationDirectoryRemovedEvent(final Application application, final Directory directory) {
        this(application, application, directory);
    }

    public ApplicationDirectoryRemovedEvent(Application oldApplication, Application newApplication, Directory directory) {
        super(oldApplication, newApplication);
        this.directory = ImmutableDirectory.from(directory);
    }

    public Directory getDirectory() {
        return directory;
    }

    // accessor for Analytics
    public Long getDirectoryId() {
        return directory.getId();
    }
}
