package com.atlassian.crowd.event;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Objects;

/**
 * Base class for events containing single enum.
 */
public class EnumBasedEvent<T extends Enum> {
    protected final T data;

    protected EnumBasedEvent(T data) {
        this.data = Objects.requireNonNull(data);
    }

    public static <E extends Enum, T> ImmutableMap<E,T> createMapByEnum(E[] enumValues, Function<E, T> constructor) {
        return Maps.toMap(Arrays.asList(enumValues), constructor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        EnumBasedEvent that = (EnumBasedEvent) o;

        return Objects.equals(this.data, that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(data);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("data", data)
                .toString();
    }
}
