package com.atlassian.crowd.event;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.model.directory.ImmutableDirectory;

/**
 * An Event that represents any operation on a {@link com.atlassian.crowd.embedded.api.Directory}
 * going via the {@link com.atlassian.crowd.manager.directory.DirectoryManager}.
 * <p>
 * These events correspond to operations performed via Crowd (eg. Crowd console, Crowd connected applications).
 */
public abstract class DirectoryEvent extends Event {
    private final ImmutableDirectory directory;

    public DirectoryEvent(Object source, Directory directory) {
        super(source);
        this.directory = ImmutableDirectory.from(directory);
    }

    public Directory getDirectory() {
        return directory;
    }

    // accessor for Analytics
    public Long getDirectoryId() {
        return directory.getId();
    }

    // accessor for Analytics
    public DirectoryType getDirectoryType() {
        return directory.getType();
    }

    // accessor for Analytics
    public String getDirectoryImplementationClass() {
        return directory.getImplementationClass();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DirectoryEvent that = (DirectoryEvent) o;

        return directory.equals(that.directory);
    }

    @Override
    public int hashCode() {
        return directory != null ? directory.hashCode() : 0;
    }
}
