package com.atlassian.crowd.event.user;

import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.User;

/**
 * An Event that represents the updating of a {@link com.atlassian.crowd.model.user.User}
 *
 * This is a generic event. Depending on what exactly happened a specific subclass will be published
 */
public abstract class UserUpdatedEvent extends DirectoryEvent {
    private final ImmutableUser user;

    public UserUpdatedEvent(Object source, Directory directory, User user) {
        super(source, directory);
        this.user = new ImmutableUser(user);
    }

    public User getUser() {
        return user;
    }
}
