package com.atlassian.crowd.event.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.User;
import com.google.common.base.Preconditions;

/**
 * An event that is published when user is edited
 */
public class UserEditedEvent extends UserUpdatedEvent {
    private final ImmutableUser originalUser;

    public UserEditedEvent(final Object source, final Directory directory, final User user, final User originalUser) {
        super(source, directory, user);
        Preconditions.checkArgument(originalUser != user);
        this.originalUser = new ImmutableUser(originalUser);
    }

    public User getOriginalUser() {
        return originalUser;
    }
}
