package com.atlassian.crowd.event.user;

import java.util.Collection;

import javax.annotation.Nullable;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.event.DirectoryEvent;

/**
 * An Event that is fired when a user (principal) attempts to change their password (credential) but it does not meet
 * the password criteria for the directory.
 */
public class UserCredentialValidationFailed extends DirectoryEvent {
    @Nullable
    private final Collection<PasswordConstraint> failedConstraints;

    public UserCredentialValidationFailed(Object source, Directory directory, @Nullable Collection<PasswordConstraint> failedConstraints) {
        super(source, directory);
        this.failedConstraints = failedConstraints;
    }

    @Nullable
    public Collection<PasswordConstraint> getFailedConstraints() {
        return failedConstraints;
    }

    @Nullable
    public String failedReason() {
        return failedConstraints != null ? failedConstraints.toString() : null;
    }
}
