package com.atlassian.crowd.event.user;

import com.atlassian.crowd.event.Event;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.User;

public class UserAuthenticationFailedAccessDeniedEvent extends Event {
    private final ImmutableUser user;
    private final ImmutableApplication application;

    public UserAuthenticationFailedAccessDeniedEvent(Object source, User user, Application application) {
        super(source);
        this.user = new ImmutableUser(user);
        this.application = ImmutableApplication.builder(application).build();
    }

    public User getRemotePrincipal() {
        return user;
    }

    public Application getApplication() {
        return application;
    }

    // accessor for Analytics
    public Long getApplicationId() {
        return application.getId();
    }
}
